﻿/*
    Sunburst: Halo Reach Game Variant Rehasher

    Copyright (c) Nuklear

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace Sunburst.Lite
{
    internal partial class FMain : Form
    {
        public FMain()
        {
            InitializeComponent();
            this.DragEnter += new DragEventHandler(FMain_DragEnter);
            this.DragDrop += new DragEventHandler(FMain_DragDrop);
        }

        private void FMain_DragDrop(object sender, DragEventArgs e)
        {
            string[] files = (e.Data.GetData(DataFormats.FileDrop) as string[]);
            foreach (var file in files)
            {
                // Create a backup file.
                var backup = Path.ChangeExtension(file, ".bak");
                if (File.Exists(backup))
                {
                    File.Delete(backup);
                }
                File.Copy(file, backup);

                // Rehash the game variant.
                GameVariant.FixHash(backup, file);
            }
        }

        private void FMain_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                e.Effect = DragDropEffects.Copy;
            }
        }
    }
}
